//=============================================================================
// Keypad control butons super class.
//=============================================================================
class KeyPadControlButtons extends DeusExDecoration;

var() float buttonLitTime;
var() sound buttonSound1;
var() sound buttonSound2;
var() bool bLit;
var() bool bWaitForEvent;
var bool isPressed;
var Vector	lastLoc, rpcLocation;
var bool		bIsMoving;

//=============================================
//new stuff------------------------------------
//=============================================
var() localized string OwnerName; //what's the house owner's name we shoud recognize?
var() bool bHasOwner;
var() MSCustomKeypad ControlledKeypad;

replication 
{
	reliable if ( Role == ROLE_Authority )
		rpcLocation;
}

function Trigger(Actor Other, Pawn Instigator)
{
	if (bWaitForEvent)
		Timer();
}

function Timer()
{
	PlaySound(buttonSound2, SLOT_None);
	isPressed = False;
}

function Frob(Actor Frobber, Inventory frobWith)
{
 if ((InStr(PlayerPawn(Frobber).PlayerReplicationInfo.PlayerName, OwnerName) == -1) && (bHasOwner))
 {
  PlayerPawn(Frobber).ClientMessage("|p2You do not own these buttons!");
  return; 
 }
 else if ((InStr(PlayerPawn(Frobber).PlayerReplicationInfo.PlayerName, OwnerName) != -1) || (!bHasOwner))
 {
  Timer();
  Super.Frob(Frobber, frobWith);
 }
}

singular function SupportActor(Actor standingActor)
{
	// do nothing
}

function Bump(actor Other)
{
	// do nothing
}

simulated function Tick( float deltaTime )
{						  	
	if ( Level.NetMode != NM_Standalone )
	{
		if ( Role == ROLE_Authority )
		{
			// Was moving, now at rest
			if ( bIsMoving && ( Location == lastLoc ))
				rpcLocation = Location;

			bIsMoving = ( Location != lastLoc );
			lastLoc = Location;
		}
		else
		{
			// Our replicated location changed which means the button has come to rest
			if ( lastLoc != rpcLocation )
			{
				SetLocation( rpcLocation );
				lastLoc = rpcLocation;
			}
		}
	}
	Super.Tick( deltaTime );
}

defaultproperties
{
     buttonLitTime=0.500000
     buttonSound1=Sound'DeusExSounds.Generic.Beep1'
     bInvincible=True
     ItemName="|p2Keypad Control Button"
     bPushable=False
     Physics=PHYS_None
     RemoteRole=ROLE_SimulatedProxy
     Mesh=LodMesh'DeusExDeco.Button1'
     CollisionRadius=2.000000
     CollisionHeight=2.000000
     bCollideWorld=False
     bBlockActors=False
     Mass=5.000000
     Buoyancy=2.000000
}
